<?php if (!defined('ABSPATH')) exit; // Exit if accessed directly ?>

<?php do_action('wpo_wcpdf_before_document', $this->get_type(), $this->order); ?>

<table class="head container">
    <tr>
        <td class="header">
            <?php
            if ($this->has_header_logo()) {
                do_action('wpo_wcpdf_before_shop_logo', $this->get_type(), $this->order);
                $this->header_logo();
                do_action('wpo_wcpdf_after_shop_logo', $this->get_type(), $this->order);
            } else {
                $this->title();
            }
            ?>
            <div class="shop-address" style="font-size: 13px; font-weight: 400; line-height: 15px; margin: 5px 0;">
                Kragman GmbH <br>
                Werner-von-Siemens-Straße 2-6, <br> 76646 Bruchsal,<br>
                Email: info@promez.ro
            </div>
        </td>
        <td class="shop-info">
            <!--            --><?php //do_action('wpo_wcpdf_before_shop_name', $this->get_type(), $this->order); ?>
            <!--            <div class="shop-name"><h3>--><?php //$this->shop_name(); ?><!--</h3></div>-->
            <!--            --><?php //do_action('wpo_wcpdf_after_shop_name', $this->get_type(), $this->order); ?>
            <!--            --><?php //do_action('wpo_wcpdf_before_shop_address', $this->get_type(), $this->order); ?>
            <!--            <div class="shop-address">--><?php //$this->shop_address(); ?><!--</div>-->
            <!--            --><?php //do_action('wpo_wcpdf_after_shop_address', $this->get_type(), $this->order); ?>
        </td>
    </tr>
</table>

<?php do_action('wpo_wcpdf_before_document_label', $this->get_type(), $this->order); ?>

<?php if ($this->has_header_logo()) : ?>
    <h1 class="document-type-label">Gutschrift</h1>
<?php endif; ?>

<?php do_action('wpo_wcpdf_after_document_label', $this->get_type(), $this->order); ?>

<table class="order-data-addresses">
    <tr>
        <td class="address billing-address">
            <?php do_action('wpo_wcpdf_before_billing_address', $this->get_type(), $this->order); ?>
            <p><?php $this->billing_address(); ?></p>
            <?php do_action('wpo_wcpdf_after_billing_address', $this->get_type(), $this->order); ?>
            <?php if (isset($this->settings['display_email'])) : ?>
                <div class="billing-email"><?php $this->billing_email(); ?></div>
            <?php endif; ?>
            <?php if (isset($this->settings['display_phone'])) : ?>
                <div class="billing-phone"><?php $this->billing_phone(); ?></div>
            <?php endif; ?>
        </td>
        <td class="address shipping-address">
            <?php if ($this->show_shipping_address()) : ?>
                <h3><?php $this->shipping_address_title(); ?></h3>
                <?php do_action('wpo_wcpdf_before_shipping_address', $this->get_type(), $this->order); ?>
                <p><?php $this->shipping_address(); ?></p>
                <?php do_action('wpo_wcpdf_after_shipping_address', $this->get_type(), $this->order); ?>
                <?php if (isset($this->settings['display_phone'])) : ?>
                    <div class="shipping-phone"><?php $this->shipping_phone(); ?></div>
                <?php endif; ?>
            <?php endif; ?>
        </td>
        <td class="order-data">
            <table>
                <?php do_action('wpo_wcpdf_before_order_data', $this->get_type(), $this->order); ?>
                <?php if (isset($this->settings['display_number'])) : ?>
                    <tr class="credit-note-number">
                        <th><?php $this->number_title(); ?></th>
                        <td><?php $this->number($this->get_type()); ?></td>
                    </tr>
                <?php endif; ?>
                <?php if (isset($this->settings['display_date'])) : ?>
                    <tr class="credit-note-date">
                        <th><?php $this->date_title(); ?></th>
                        <td><?php $this->date($this->get_type()); ?></td>
                    </tr>
                <?php endif; ?>
                <tr class="order-number">
                    <th><?php $this->order_number_title(); ?></th>
                    <td><?php $this->order_number(); ?></td>
                </tr>
                <tr class="order-date">
                    <th><?php $this->order_date_title(); ?></th>
                    <td><?php $this->order_date(); ?></td>
                </tr>
                <?php do_action('wpo_wcpdf_after_order_data', $this->get_type(), $this->order); ?>
            </table>
        </td>
    </tr>
</table>

<?php do_action('wpo_wcpdf_before_order_details', $this->get_type(), $this->order); ?>

<table class="order-details">
    <?php $headers = wpo_wcpdf_get_simple_template_default_table_headers($this); ?>
    <thead>
    <tr>
        <?php
        foreach ($headers as $column_class => $column_title) {
            printf('<th class="%s">%s</th>', $column_class, $column_title);
        }
        ?>
    </tr>
    </thead>
    <tbody>
    <?php
    $index = 0;
    foreach ($this->get_order_items() as $item_id => $item) :
        $index++;
        ?>
        <tr class="<?php echo apply_filters('wpo_wcpdf_item_row_class', 'item-' . $item_id, esc_attr($this->get_type()), $this->order, $item_id); ?>">
            <td class="index"><?php echo $index ?></td>
            <td class="quantity"><?php echo esc_html($item['quantity']); ?>.00</td>
            <td class="cod">
                <?php if (!empty($item['sku'])) : ?>
                    <p class="sku"><span
                                class="label"></span> <?php echo esc_attr($item['sku']); ?>
                    </p>
                <?php endif; ?>
            </td>
            <td class="product">
                <p class="item-name"><?php echo $item['name']; ?></p>
                <?php do_action('wpo_wcpdf_before_item_meta', $this->get_type(), $item, $this->order); ?>
                <?php do_action('wpo_wcpdf_after_item_meta', $this->get_type(), $item, $this->order); ?>
            </td>
            <td class="tva">7.00%</td>
            <td class="price"><?php echo esc_html($item['single_price']); ?></td>
            <td class="price last_price"><?php echo esc_html($item['order_price']); ?></td>
        </tr>
        <?php

        $tips_raw = get_post_meta($this->order->get_id(), '_custom_tip_amount', true);
        $tips = is_numeric($tips_raw) ? (float)$tips_raw : 0.00;

        echo $index++;
        if ($tips) : ?>
            <tr>
                <td><?php echo $index ?></td>
                <td class="quantity">1.00</td>
                <td class="cod"></td>
                <td class="product">Tip</td>
                <td class="tva">0.00%</td>
                <td class="price"><?php echo wc_price($tips); ?></td>
                <td class="price last_price"><?php echo wc_price($tips); ?></td>
            </tr>
        <?php endif; ?>
    <?php endforeach; ?>
    </tbody>
</table>

<table class="notes-totals">
    <tbody>
    <tr class="no-borders">
        <td class="no-borders notes-cell">
            <?php do_action('wpo_wcpdf_before_customer_notes', $this->get_type(), $this->order); ?>
            <?php if ($this->get_shipping_notes()) : ?>
                <div class="customer-notes refund-reason">
                    <h3><?php $this->refund_reason_title(); ?></h3>
                    <?php $this->shipping_notes(); ?>
                </div>
            <?php endif; ?>
            <?php do_action('wpo_wcpdf_after_customer_notes', $this->get_type(), $this->order); ?>
        </td>
        <td class="no-borders totals-cell">
            <table class="totals">
                <tfoot>
                <?php
                $totals = $this->get_woocommerce_totals();

                $order_total_float = 0.0;

                if (isset($totals['order_total']['value'])) {
                    // Extragem partea numerică, ex: "83,19" din "83,19€(inkl. 5,22€ TVA)"
                    preg_match('/[\d\.,]+/', $totals['order_total']['value'], $matches);

                    if (!empty($matches)) {
                        // Convertim din format european (virgulă = punct zecimal) în float
                        $order_total_float = floatval(str_replace(',', '.', $matches[0]));
                    }
                }
                $total_brut = $order_total_float;

                $net = $total_brut / 1.07;

                $tva = $total_brut - $net;


                ?>
                <tr>
                    <th>Gesamt Netto (7.00 %)</th>
                    <td style="text-align: right;"><?php echo round($net, 2) ?>€</td>
                </tr>
                <tr>
                    <th>zzgl. MwSt (7.00%)</th>
                    <td style="text-align: right;"><?php echo round($tva, 2) ?>€</td>
                </tr>
                <?php foreach ($this->get_woocommerce_totals() as $key => $total) : ?>
                    <tr class="<?php echo esc_attr($key); ?>">
                        <th class="description"><?php echo $total['label']; ?></th>
                        <td class="price" style="text-align: right;"><span
                                    class="totals-price"><?php echo $total['value']; ?></span></td>
                    </tr>
                <?php endforeach; ?>
                </tfoot>
            </table>
        </td>
    </tr>
    </tbody>
</table>

<?php do_action('wpo_wcpdf_after_order_details', $this->get_type(), $this->order); ?>

<div class="bottom-spacer"></div>

<?php if ($this->get_footer()) : ?>
    <htmlpagefooter name="docFooter"><!-- required for mPDF engine -->
        <div id="footer">
            <!-- hook available: wpo_wcpdf_before_footer -->
            <?php $this->footer(); ?>
            <!-- hook available: wpo_wcpdf_after_footer -->
        </div>
    </htmlpagefooter><!-- required for mPDF engine -->
<?php endif; ?>

<?php do_action('wpo_wcpdf_after_document', $this->get_type(), $this->order); ?>
